/*	Renegade Scripts.dll
	SSGM keyhook scripts
	Copyright 2007 WhiteDragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/


#include "scripts.h"
#include "engine.h"
#include "gmkeyhook.h"
#include "gmmain.h" 


void KeyHookCall(void *Data2) {
	MDB_SSGM_KeyHook *Base = (MDB_SSGM_KeyHook *)Data2;
	Base->KeyHookFunc();
}

int MDB_SSGM_KeyHook::AddHook(const char *Key, GameObject *obj) {
	if (is_keyhook_set == 1337) {
		RemoveHook();
	}
	k = 0;
	k = new KeyHookStruct;
	k->data = this;
	k->hook = KeyHookCall;
	k->PlayerID = Get_Player_ID(obj);
	k->key = newstr(Key);
	hookid = AddKeyHook(k);
	return hookid;
}

void MDB_SSGM_KeyHook::RemoveHook() {
	if (hookid != 0 && RemoveKeyHook != 0) {
		RemoveKeyHook(hookid);
		hookid = 0;
		if (k != 0) {
			delete[] k->key;
			delete k;
			k = 0;
		}
	}
}

void MDB_SSGM_KeyHook::Detach(GameObject *obj) {
	if (is_keyhook_set == 1337) {
		RemoveHook();
	}
}

void MDB_SSGM_KeyHook::Destroyed(GameObject *obj) {
	if (is_keyhook_set == 1337) {
		RemoveHook();
	}
}

void MDB_SSGM_Taunt_Key::Created(GameObject *obj) {
	if (is_keyhook_set != 1337) {
		hookid = AddHook(Get_Parameter("Key"),obj);
		is_keyhook_set = 1337;
	}
}

void MDB_SSGM_Taunt_Key::KeyHookFunc() {
	if (Get_Vehicle(Owner()) == 0) {
		Commands->Set_Animation(Owner(),Get_Parameter("Anim"),false,0,0.0f,-1.0f,false);
	}
}

void MDB_SSGM_WriteLog_Key::Created(GameObject *obj) {
	if (is_keyhook_set != 1337) {
		hookid = AddHook(Get_Parameter("Key"),obj);
		LastPress = The_Game()->GameDuration_Seconds-8;
		is_keyhook_set = 1337;
	}
}

void MDB_SSGM_WriteLog_Key::KeyHookFunc() {
	char message[100];
	if ((The_Game()->GameDuration_Seconds - LastPress) >= 8) {
		if (Get_Int_Parameter("Type") == 0) {
			sprintf(message,"%ls: %s",Get_Wide_Player_Name(Owner()),Get_Parameter("Write"));
		}
		else {
			sprintf(message,"[Team] %ls: %s",Get_Wide_Player_Name(Owner()),Get_Parameter("Write"));
		}
		WriteLog(message,false);
		LastPress = The_Game()->GameDuration_Seconds;
	}
}

void MDB_SSGM_ChatCommand_Key::Created(GameObject *obj) {
	if (is_keyhook_set != 1337) {
		hookid = AddHook(Get_Parameter("Key"),obj);
		LastPress = The_Game()->GameDuration_Seconds-5;
		is_keyhook_set = 1337;
	}
}

void MDB_SSGM_ChatCommand_Key::KeyHookFunc() {
	if ((The_Game()->GameDuration_Seconds - LastPress) >= 5) {
		Data->Trigger_Chat_Command(Get_Player_ID(Owner()),Get_Int_Parameter("ChatType"),Get_Parameter("Command"),TokenClass());
		LastPress = The_Game()->GameDuration_Seconds;
	}
}

ScriptRegistrant<MDB_SSGM_Taunt_Key> MDB_SSGM_Taunt_Key_Registrant("MDB_SSGM_Taunt_Key","Key:string,Anim:string");
ScriptRegistrant<MDB_SSGM_WriteLog_Key> MDB_SSGM_WriteLog_Key_Registrant ("MDB_SSGM_WriteLog_Key","Key:string,Write:string,Type:int");
ScriptRegistrant<MDB_SSGM_ChatCommand_Key> MDB_SSGM_ChatCommand_Key_Registrant("MDB_SSGM_ChatCommand_Key","Key:string,Command:string,ChatType:int");
